#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Procedural GlobeMod01.fsh    by    PrzemyslawZaworski  
//https://www.shadertoy.com/view/llscW7
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Author: Przemyslaw Zaworski, 12.09.2017, version 1.1
//License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.


float generate_map = 50.0;

const int ssaa=4;

mat2 rotation(float x)
{
    return mat2(cos(x),-sin(x),sin(x),cos(x));
}

float noise (vec3 n) 
{ 
	return fract(sin(dot(n, vec3(95.43583, 93.323197, 94.993431))) * 65536.32);
}

float perlin_a (vec3 n)
{
    vec3 x = floor(n * 64.0) * 0.015625;
    vec3 k = vec3(0.015625, 0.0, 0.0);
    float a = noise(x);
    float b = noise(x + k.xyy);
    float c = noise(x + k.yxy);
    float d = noise(x + k.xxy);
    vec3 p = (n - x) * 64.0;
    float u = mix(a, b, p.x);
    float v = mix(c, d, p.x);
    return mix(u,v,p.y);
}

float perlin_b (vec3 n)
{
    vec3 base = vec3(n.x, n.y, floor(n.z * 64.0) * 0.015625);
    vec3 dd = vec3(0.015625, 0.0, 0.0);
    vec3 p = (n - base) *  64.0;
    float front = perlin_a(base + dd.yyy);
    float back = perlin_a(base + dd.yyx);
    return mix(front, back, p.z);
}

float fbm(vec3 n)
{
    float t = 0.0;
    float a = 1.0;
    float b = 0.1;
    for (int i = 0; i < 5; i++)
    {
        t += perlin_b(n * a) * b;
        a *= 0.5;
        b *= 2.0;
    }
    return t;
}

vec3 heightmap (vec3 n)
{
	return vec3(fbm((5.0 * n) + fbm((5.0 * n) * 3.0 - 1000.0) * 0.05),0,0);
}

vec3 grid(vec2 p)
{
    return vec3(1.0)*smoothstep(0.99,1.0,max(sin((p.x)*20.0),sin((p.y)*20.0)));
}

float sphere(vec3 ro, vec3 rd)
{
    float b = dot(ro,rd);
    float c = dot(ro,ro)-1.0;
    float h = b*b-c;
    return (h<0.0)?-1.0:-b-sqrt(h);
}

vec3 atlas(vec2 uv)
{    
 	float color = clamp(vec4(vec3((heightmap(vec3(uv*5.0,generate_map)*0.02)-1.0)),1.0).r,0.0,1.0);
    return 
    color<0.10 ? vec3(0.77,0.90,0.98):
    color<0.20 ? vec3(0.82,0.92,0.99):
    color<0.30 ? vec3(0.91,0.97,0.99):
    color<0.55 ? vec3(0.62,0.75,0.59):
    color<0.65 ? vec3(0.86,0.90,0.68):
    color<0.75 ? vec3(0.99,0.99,0.63):
    color<0.85 ? vec3(0.99,0.83,0.59):
    color<0.95 ? vec3(0.98,0.71,0.49):     
    color<0.99 ? vec3(0.98,0.57,0.47):              
    vec3(0.79,0.48,0.43); 
}

vec3 raycast (vec3 ro, vec3 rd, vec2 p)
{
    float t = sphere(ro,rd);
    if (t > 0.0)
    {
    	vec3 d = ro+rd*t;
        p=vec2(acos(d.y/length(d)), atan(d.z,d.x));  
        return (atlas(p).xyz+grid(p*3.0));        
    } 
    return 1.7-vec3(length(p));;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 	
	vec3 c = vec3(0.0);
	for (int m=0;m<ssaa;m++)
	{
		for (int n=0;n<ssaa;n++)
		{
			vec2 offset = vec2(float(m),float(n))/float(ssaa)-0.5;
			vec2 p = (fragCoord.xy+offset.xy)/iResolution.xy-0.5;	
            p.x*=iResolution.x/iResolution.y;
            vec2 m = iMouse.xy / iResolution.xy-0.5;
            m.x *= iResolution.x/iResolution.y;
            p*= 1.5;
            vec3 ro = vec3(0.0,0.0,2.4);
            vec3 rd = normalize(vec3(p,-1.5));
            mat2 rx = rotation(iTime*0.4+m.x*5.0);
            ro.xz *= rx; rd.xz *= rx;  
			c+=raycast(ro,rd,p);
		}
	}
	c=c/float(ssaa*ssaa);    
	fragColor = vec4(c, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

